"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const Nav_module = require("./Nav.module.css.cjs");
const NavBar = ({
  children,
  className,
  role,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const classes = classNames(className, Nav_module.default["nav-bar"]);
  const a11yAttributesForNav = role !== "tablist" ? (
    /**
     * If role isn't tablist, default to navigation.
     */
    { role: "navigation", "aria-label": ariaLabel }
  ) : (
    /**
     * If role is tablist, give nav presentation role to remove
     * any semantic meaning.
     */
    { role: "presentation" }
  );
  const a11yAttributesForUl = role === "tablist" ? { role: "tablist", "aria-label": ariaLabel } : {};
  return /* @__PURE__ */ jsxRuntime.jsx("nav", { ...a11yAttributesForNav, ...rest, className: classes, children: /* @__PURE__ */ jsxRuntime.jsx("ul", { ...a11yAttributesForUl, className: Nav_module.default["nav-bar-items"], children }) });
};
exports.NavBar = NavBar;
//# sourceMappingURL=NavBar.cjs.map
