import { jsx } from "react/jsx-runtime";
import { forwardRef, useId, useCallback } from "react";
import { MenuItem } from "./MenuItem.js";
import { ToggleInput } from "../Form/Controls/Toggle/Toggle.js";
const ToggleMenuItem = forwardRef(
  function ToggleMenuItem2({ className, Icon, label, onSelect, checked, disabled, onClick }, ref) {
    const toggleId = useId();
    const onChange = useCallback(() => {
    }, []);
    return /* @__PURE__ */ jsx(
      MenuItem,
      {
        as: "div",
        role: "menuitemcheckbox",
        "aria-checked": checked,
        className,
        Icon,
        label,
        onSelect,
        disabled,
        onClick,
        children: /* @__PURE__ */ jsx(
          ToggleInput,
          {
            id: toggleId,
            ref,
            "aria-hidden": true,
            checked,
            disabled,
            onChange
          }
        )
      }
    );
  }
);
export {
  ToggleMenuItem
};
//# sourceMappingURL=ToggleMenuItem.js.map
