import { jsx } from "react/jsx-runtime";
import { forwardRef, useId, useCallback } from "react";
import { MenuItem } from "./MenuItem.js";
import { RadioInput } from "../Form/Controls/Radio/Radio.js";
const RadioMenuItem = forwardRef(
  function RadioMenuItem2({ className, label, onSelect, checked, disabled }, ref) {
    const toggleId = useId();
    const onChange = useCallback(() => {
    }, []);
    return /* @__PURE__ */ jsx(
      MenuItem,
      {
        as: "div",
        role: "menuitemradio",
        "aria-checked": checked,
        className,
        label,
        onSelect,
        disabled,
        Icon: /* @__PURE__ */ jsx(
          RadioInput,
          {
            id: toggleId,
            ref,
            "aria-hidden": true,
            checked,
            disabled,
            onChange
          }
        )
      }
    );
  }
);
export {
  RadioMenuItem
};
//# sourceMappingURL=RadioMenuItem.js.map
