"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const MenuItem = require("./MenuItem.cjs");
const Radio = require("../Form/Controls/Radio/Radio.cjs");
const RadioMenuItem = React.forwardRef(
  function RadioMenuItem2({ className, label, onSelect, checked, disabled }, ref) {
    const toggleId = React.useId();
    const onChange = React.useCallback(() => {
    }, []);
    return /* @__PURE__ */ jsxRuntime.jsx(
      MenuItem.MenuItem,
      {
        as: "div",
        role: "menuitemradio",
        "aria-checked": checked,
        className,
        label,
        onSelect,
        disabled,
        Icon: /* @__PURE__ */ jsxRuntime.jsx(
          Radio.RadioInput,
          {
            id: toggleId,
            ref,
            "aria-hidden": true,
            checked,
            disabled,
            onChange
          }
        )
      }
    );
  }
);
exports.RadioMenuItem = RadioMenuItem;
//# sourceMappingURL=RadioMenuItem.cjs.map
