import { jsx } from "react/jsx-runtime";
import { Text } from "../Typography/Text.js";
import styles from "./MenuTitle.module.css.js";
import classNames from "classnames";
const MenuTitle = ({
  title,
  id,
  className
}) => {
  const classes = classNames(styles["menu-title"], className);
  return /* @__PURE__ */ jsx(Text, { as: "h3", id, className: classes, size: "sm", weight: "semibold", children: title });
};
export {
  MenuTitle
};
//# sourceMappingURL=MenuTitle.js.map
