import { jsxs, jsx } from "react/jsx-runtime";
import classNames from "classnames";
import { useContext, useCallback, isValidElement } from "react";
import styles from "./MenuItem.module.css.js";
import { Text } from "../Typography/Text.js";
import ChevronRightIcon from "@vector-im/compound-design-tokens/assets/web/icons/chevron-right";
import { MenuContext } from "./MenuContext.js";
import { Slot } from "@radix-ui/react-slot";
const MenuItem = ({
  as,
  className,
  Icon,
  label,
  labelProps,
  onSelect,
  kind = "primary",
  children,
  onClick: onClickProp,
  disabled,
  hideChevron,
  ...props
}) => {
  const Component = as ?? "button";
  const context = useContext(MenuContext);
  const onClick = useCallback(
    (e) => {
      onClickProp?.(e);
      if (onSelect !== null && context?.MenuItemWrapper == null) {
        const selectEvent = new CustomEvent("menu.itemSelect", {
          bubbles: true,
          cancelable: true
        });
        onSelect(selectEvent);
        if (!selectEvent.defaultPrevented) context?.onOpenChange(false);
      }
    },
    [context, onSelect]
  );
  const iconIsReactElement = isValidElement(Icon);
  const componentIcon = Icon;
  const SvgIcon = Icon;
  const content = /* @__PURE__ */ jsxs(
    Component,
    {
      role: "menuitem",
      ...props,
      className: classNames(className, styles.item, {
        [styles.interactive]: onSelect !== null,
        [styles["no-label"]]: label === null,
        [styles["no-icon"]]: !Icon,
        [styles["disabled"]]: disabled
      }),
      "data-kind": kind,
      onClick,
      disabled: Component === "button" ? disabled : void 0,
      "aria-disabled": Component === "button" ? void 0 : disabled,
      children: [
        Icon && (iconIsReactElement ? /* @__PURE__ */ jsx(Slot, { className: styles.icon, children: componentIcon }) : /* @__PURE__ */ jsx(
          SvgIcon,
          {
            width: 24,
            height: 24,
            className: styles.icon,
            "aria-hidden": true
          }
        )),
        label !== null && /* @__PURE__ */ jsx(
          Text,
          {
            className: styles.label,
            size: "md",
            weight: "medium",
            as: "span",
            ...labelProps,
            children: label
          }
        ),
        !hideChevron && (Component === "button" || Component === "a") && /* @__PURE__ */ jsx(
          ChevronRightIcon,
          {
            width: 8,
            height: 24,
            className: styles["nav-hint"],
            "aria-hidden": true,
            viewBox: "8 0 8 24"
          }
        ),
        children
      ]
    }
  );
  return context?.MenuItemWrapper == null || onSelect === null ? content : /* @__PURE__ */ jsx(context.MenuItemWrapper, { onSelect, children: content });
};
export {
  MenuItem
};
//# sourceMappingURL=MenuItem.js.map
