"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const MenuItem_module = require("./MenuItem.module.css.cjs");
const Text = require("../Typography/Text.cjs");
const ChevronRightIcon = require("@vector-im/compound-design-tokens/assets/web/icons/chevron-right");
const MenuContext = require("./MenuContext.cjs");
const reactSlot = require("@radix-ui/react-slot");
const MenuItem = ({
  as,
  className,
  Icon,
  label,
  labelProps,
  onSelect,
  kind = "primary",
  children,
  onClick: onClickProp,
  disabled,
  hideChevron,
  ...props
}) => {
  const Component = as ?? "button";
  const context = React.useContext(MenuContext.MenuContext);
  const onClick = React.useCallback(
    (e) => {
      onClickProp?.(e);
      if (onSelect !== null && context?.MenuItemWrapper == null) {
        const selectEvent = new CustomEvent("menu.itemSelect", {
          bubbles: true,
          cancelable: true
        });
        onSelect(selectEvent);
        if (!selectEvent.defaultPrevented) context?.onOpenChange(false);
      }
    },
    [context, onSelect]
  );
  const iconIsReactElement = React.isValidElement(Icon);
  const componentIcon = Icon;
  const SvgIcon = Icon;
  const content = /* @__PURE__ */ jsxRuntime.jsxs(
    Component,
    {
      role: "menuitem",
      ...props,
      className: classNames(className, MenuItem_module.default.item, {
        [MenuItem_module.default.interactive]: onSelect !== null,
        [MenuItem_module.default["no-label"]]: label === null,
        [MenuItem_module.default["no-icon"]]: !Icon,
        [MenuItem_module.default["disabled"]]: disabled
      }),
      "data-kind": kind,
      onClick,
      disabled: Component === "button" ? disabled : void 0,
      "aria-disabled": Component === "button" ? void 0 : disabled,
      children: [
        Icon && (iconIsReactElement ? /* @__PURE__ */ jsxRuntime.jsx(reactSlot.Slot, { className: MenuItem_module.default.icon, children: componentIcon }) : /* @__PURE__ */ jsxRuntime.jsx(
          SvgIcon,
          {
            width: 24,
            height: 24,
            className: MenuItem_module.default.icon,
            "aria-hidden": true
          }
        )),
        label !== null && /* @__PURE__ */ jsxRuntime.jsx(
          Text.Text,
          {
            className: MenuItem_module.default.label,
            size: "md",
            weight: "medium",
            as: "span",
            ...labelProps,
            children: label
          }
        ),
        !hideChevron && (Component === "button" || Component === "a") && /* @__PURE__ */ jsxRuntime.jsx(
          ChevronRightIcon,
          {
            width: 8,
            height: 24,
            className: MenuItem_module.default["nav-hint"],
            "aria-hidden": true,
            viewBox: "8 0 8 24"
          }
        ),
        children
      ]
    }
  );
  return context?.MenuItemWrapper == null || onSelect === null ? content : /* @__PURE__ */ jsxRuntime.jsx(context.MenuItemWrapper, { onSelect, children: content });
};
exports.MenuItem = MenuItem;
//# sourceMappingURL=MenuItem.cjs.map
