import { jsx, jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Root, Trigger, Portal, Content, DropdownMenuItem } from "@radix-ui/react-dropdown-menu";
import { FloatingMenu } from "./FloatingMenu.js";
import { Drawer } from "vaul";
import classNames from "classnames";
import drawerMenu from "./DrawerMenu.module.css.js";
import { MenuContext } from "./MenuContext.js";
import { DrawerMenu } from "./DrawerMenu.js";
import { getPlatform } from "../../utils/platform.js";
const DropdownMenuItemWrapper = ({
  onSelect,
  children
}) => /* @__PURE__ */ jsx(DropdownMenuItem, { onSelect: onSelect ?? void 0, asChild: true, children });
const Menu = ({
  title,
  showTitle = true,
  open,
  onOpenChange,
  trigger,
  children: childrenProp,
  side = "bottom",
  align = "center"
}) => {
  const platform = getPlatform();
  const drawer = platform === "android" || platform === "ios";
  const context = useMemo(
    () => ({
      MenuItemWrapper: drawer ? null : DropdownMenuItemWrapper,
      onOpenChange
    }),
    [onOpenChange]
  );
  const children = /* @__PURE__ */ jsx(MenuContext.Provider, { value: context, children: childrenProp });
  return drawer ? /* @__PURE__ */ jsxs(Drawer.Root, { open, onOpenChange, children: [
    /* @__PURE__ */ jsx(Drawer.Trigger, { asChild: true, children: trigger }),
    /* @__PURE__ */ jsxs(Drawer.Portal, { children: [
      /* @__PURE__ */ jsx(Drawer.Overlay, { className: classNames(drawerMenu.bg) }),
      /* @__PURE__ */ jsx(Drawer.Content, { asChild: true, children: /* @__PURE__ */ jsx(DrawerMenu, { title, children }) })
    ] })
  ] }) : /* @__PURE__ */ jsxs(Root, { open, onOpenChange, children: [
    /* @__PURE__ */ jsx(Trigger, { asChild: true, children: trigger }),
    /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(Content, { asChild: true, side, align, sideOffset: 8, children: /* @__PURE__ */ jsx(FloatingMenu, { title, showTitle, children }) }) })
  ] });
};
export {
  Menu
};
//# sourceMappingURL=Menu.js.map
