"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactDropdownMenu = require("@radix-ui/react-dropdown-menu");
const FloatingMenu = require("./FloatingMenu.cjs");
const vaul = require("vaul");
const classNames = require("classnames");
const DrawerMenu_module = require("./DrawerMenu.module.css.cjs");
const MenuContext = require("./MenuContext.cjs");
const DrawerMenu = require("./DrawerMenu.cjs");
const platform = require("../../utils/platform.cjs");
const DropdownMenuItemWrapper = ({
  onSelect,
  children
}) => /* @__PURE__ */ jsxRuntime.jsx(reactDropdownMenu.DropdownMenuItem, { onSelect: onSelect ?? void 0, asChild: true, children });
const Menu = ({
  title,
  showTitle = true,
  open,
  onOpenChange,
  trigger,
  children: childrenProp,
  side = "bottom",
  align = "center"
}) => {
  const platform$1 = platform.getPlatform();
  const drawer = platform$1 === "android" || platform$1 === "ios";
  const context = React.useMemo(
    () => ({
      MenuItemWrapper: drawer ? null : DropdownMenuItemWrapper,
      onOpenChange
    }),
    [onOpenChange]
  );
  const children = /* @__PURE__ */ jsxRuntime.jsx(MenuContext.MenuContext.Provider, { value: context, children: childrenProp });
  return drawer ? /* @__PURE__ */ jsxRuntime.jsxs(vaul.Drawer.Root, { open, onOpenChange, children: [
    /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Trigger, { asChild: true, children: trigger }),
    /* @__PURE__ */ jsxRuntime.jsxs(vaul.Drawer.Portal, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Overlay, { className: classNames(DrawerMenu_module.default.bg) }),
      /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Content, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(DrawerMenu.DrawerMenu, { title, children }) })
    ] })
  ] }) : /* @__PURE__ */ jsxRuntime.jsxs(reactDropdownMenu.Root, { open, onOpenChange, children: [
    /* @__PURE__ */ jsxRuntime.jsx(reactDropdownMenu.Trigger, { asChild: true, children: trigger }),
    /* @__PURE__ */ jsxRuntime.jsx(reactDropdownMenu.Portal, { children: /* @__PURE__ */ jsxRuntime.jsx(reactDropdownMenu.Content, { asChild: true, side, align, sideOffset: 8, children: /* @__PURE__ */ jsxRuntime.jsx(FloatingMenu.FloatingMenu, { title, showTitle, children }) }) })
  ] });
};
exports.Menu = Menu;
//# sourceMappingURL=Menu.cjs.map
