import { jsxs, jsx } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef, useId } from "react";
import styles from "./FloatingMenu.module.css.js";
import { MenuTitle } from "./MenuTitle.js";
const FloatingMenu = forwardRef(
  ({ title, showTitle = true, className, children, ...props }, ref) => {
    const titleId = useId();
    return /* @__PURE__ */ jsxs(
      "div",
      {
        role: "menu",
        ref,
        "aria-label": showTitle ? void 0 : title,
        "aria-labelledby": showTitle ? titleId : void 0,
        className: classNames(className, styles.menu),
        ...props,
        children: [
          showTitle && /* @__PURE__ */ jsx(MenuTitle, { className: styles.title, title, id: titleId }),
          children
        ]
      }
    );
  }
);
FloatingMenu.displayName = "FloatingMenu";
export {
  FloatingMenu
};
//# sourceMappingURL=FloatingMenu.js.map
