"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const FloatingMenu_module = require("./FloatingMenu.module.css.cjs");
const MenuTitle = require("./MenuTitle.cjs");
const FloatingMenu = React.forwardRef(
  ({ title, showTitle = true, className, children, ...props }, ref) => {
    const titleId = React.useId();
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        role: "menu",
        ref,
        "aria-label": showTitle ? void 0 : title,
        "aria-labelledby": showTitle ? titleId : void 0,
        className: classNames(className, FloatingMenu_module.default.menu),
        ...props,
        children: [
          showTitle && /* @__PURE__ */ jsxRuntime.jsx(MenuTitle.MenuTitle, { className: FloatingMenu_module.default.title, title, id: titleId }),
          children
        ]
      }
    );
  }
);
FloatingMenu.displayName = "FloatingMenu";
exports.FloatingMenu = FloatingMenu;
//# sourceMappingURL=FloatingMenu.cjs.map
