import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import drawerMenu from "./DrawerMenu.module.css.js";
import { getPlatform } from "../../utils/platform.js";
import classNames from "classnames";
const DrawerMenu = forwardRef(
  ({ title, children, className, ...props }, ref) => /* @__PURE__ */ jsx(
    "div",
    {
      ref,
      className: classNames(className, drawerMenu.drawer),
      "aria-label": title,
      "data-platform": getPlatform(),
      ...props,
      role: "menu",
      children: /* @__PURE__ */ jsx("div", { className: drawerMenu.body, children })
    }
  )
);
DrawerMenu.displayName = "DrawerMenu";
export {
  DrawerMenu
};
//# sourceMappingURL=DrawerMenu.js.map
