"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const DrawerMenu_module = require("./DrawerMenu.module.css.cjs");
const platform = require("../../utils/platform.cjs");
const classNames = require("classnames");
const DrawerMenu = React.forwardRef(
  ({ title, children, className, ...props }, ref) => /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref,
      className: classNames(className, DrawerMenu_module.default.drawer),
      "aria-label": title,
      "data-platform": platform.getPlatform(),
      ...props,
      role: "menu",
      children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: DrawerMenu_module.default.body, children })
    }
  )
);
DrawerMenu.displayName = "DrawerMenu";
exports.DrawerMenu = DrawerMenu;
//# sourceMappingURL=DrawerMenu.cjs.map
