import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { useState, useCallback, useMemo } from "react";
import { Root, Portal, Content, ContextMenuItem, Trigger } from "@radix-ui/react-context-menu";
import { FloatingMenu } from "./FloatingMenu.js";
import { Drawer } from "vaul";
import classNames from "classnames";
import drawerMenu from "./DrawerMenu.module.css.js";
import contextStyles from "./ContextMenu.module.css.js";
import { MenuContext } from "./MenuContext.js";
import { DrawerMenu } from "./DrawerMenu.js";
import { getPlatform } from "../../utils/platform.js";
const ContextMenuItemWrapper = ({
  onSelect,
  children
}) => /* @__PURE__ */ jsx(ContextMenuItem, { onSelect: onSelect ?? void 0, asChild: true, children });
const ContextMenu = ({
  title,
  showTitle = true,
  onOpenChange: onOpenChangeProp,
  trigger: triggerProp,
  hasAccessibleAlternative,
  children: childrenProp
}) => {
  const [open, setOpen] = useState(false);
  const onOpenChange = useCallback(
    (value) => {
      setOpen(value);
      onOpenChangeProp?.(value);
    },
    [setOpen, onOpenChangeProp]
  );
  const platform = getPlatform();
  const drawer = platform === "android" || platform === "ios";
  const context = useMemo(
    () => ({
      MenuItemWrapper: drawer ? null : ContextMenuItemWrapper,
      onOpenChange
    }),
    [onOpenChange]
  );
  const children = /* @__PURE__ */ jsx(MenuContext.Provider, { value: context, children: childrenProp });
  const trigger = /* @__PURE__ */ jsx(
    Trigger,
    {
      "aria-haspopup": "menu",
      tabIndex: hasAccessibleAlternative ? void 0 : 0,
      asChild: true,
      children: triggerProp
    }
  );
  return drawer ? /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(Root, { onOpenChange, children: trigger }),
    /* @__PURE__ */ jsx(Drawer.Root, { open, onOpenChange, children: /* @__PURE__ */ jsxs(Drawer.Portal, { children: [
      /* @__PURE__ */ jsx(Drawer.Overlay, { className: classNames(drawerMenu.bg) }),
      /* @__PURE__ */ jsx(Drawer.Content, { asChild: true, children: /* @__PURE__ */ jsx(DrawerMenu, { title, children }) })
    ] }) })
  ] }) : /* @__PURE__ */ jsxs(Root, { onOpenChange, children: [
    trigger,
    /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(Content, { asChild: true, className: classNames(contextStyles.content), children: /* @__PURE__ */ jsx(FloatingMenu, { showTitle, title, children }) }) })
  ] });
};
export {
  ContextMenu
};
//# sourceMappingURL=ContextMenu.js.map
