"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactContextMenu = require("@radix-ui/react-context-menu");
const FloatingMenu = require("./FloatingMenu.cjs");
const vaul = require("vaul");
const classNames = require("classnames");
const DrawerMenu_module = require("./DrawerMenu.module.css.cjs");
const ContextMenu_module = require("./ContextMenu.module.css.cjs");
const MenuContext = require("./MenuContext.cjs");
const DrawerMenu = require("./DrawerMenu.cjs");
const platform = require("../../utils/platform.cjs");
const ContextMenuItemWrapper = ({
  onSelect,
  children
}) => /* @__PURE__ */ jsxRuntime.jsx(reactContextMenu.ContextMenuItem, { onSelect: onSelect ?? void 0, asChild: true, children });
const ContextMenu = ({
  title,
  showTitle = true,
  onOpenChange: onOpenChangeProp,
  trigger: triggerProp,
  hasAccessibleAlternative,
  children: childrenProp
}) => {
  const [open, setOpen] = React.useState(false);
  const onOpenChange = React.useCallback(
    (value) => {
      setOpen(value);
      onOpenChangeProp?.(value);
    },
    [setOpen, onOpenChangeProp]
  );
  const platform$1 = platform.getPlatform();
  const drawer = platform$1 === "android" || platform$1 === "ios";
  const context = React.useMemo(
    () => ({
      MenuItemWrapper: drawer ? null : ContextMenuItemWrapper,
      onOpenChange
    }),
    [onOpenChange]
  );
  const children = /* @__PURE__ */ jsxRuntime.jsx(MenuContext.MenuContext.Provider, { value: context, children: childrenProp });
  const trigger = /* @__PURE__ */ jsxRuntime.jsx(
    reactContextMenu.Trigger,
    {
      "aria-haspopup": "menu",
      tabIndex: hasAccessibleAlternative ? void 0 : 0,
      asChild: true,
      children: triggerProp
    }
  );
  return drawer ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(reactContextMenu.Root, { onOpenChange, children: trigger }),
    /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Root, { open, onOpenChange, children: /* @__PURE__ */ jsxRuntime.jsxs(vaul.Drawer.Portal, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Overlay, { className: classNames(DrawerMenu_module.default.bg) }),
      /* @__PURE__ */ jsxRuntime.jsx(vaul.Drawer.Content, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(DrawerMenu.DrawerMenu, { title, children }) })
    ] }) })
  ] }) : /* @__PURE__ */ jsxRuntime.jsxs(reactContextMenu.Root, { onOpenChange, children: [
    trigger,
    /* @__PURE__ */ jsxRuntime.jsx(reactContextMenu.Portal, { children: /* @__PURE__ */ jsxRuntime.jsx(reactContextMenu.Content, { asChild: true, className: classNames(ContextMenu_module.default.content), children: /* @__PURE__ */ jsxRuntime.jsx(FloatingMenu.FloatingMenu, { showTitle, title, children }) }) })
  ] });
};
exports.ContextMenu = ContextMenu;
//# sourceMappingURL=ContextMenu.cjs.map
