import { jsx } from "react/jsx-runtime";
import { forwardRef, useId, useCallback } from "react";
import { MenuItem } from "./MenuItem.js";
import { CheckboxInput } from "../Form/Controls/Checkbox/Checkbox.js";
const CheckboxMenuItem = forwardRef(
  function CheckboxMenuItem2({ className, label, onSelect, checked, disabled }, ref) {
    const toggleId = useId();
    const onChange = useCallback(() => {
    }, []);
    return /* @__PURE__ */ jsx(
      MenuItem,
      {
        as: "div",
        role: "menuitemcheckbox",
        "aria-checked": checked,
        className,
        label,
        onSelect,
        disabled,
        Icon: /* @__PURE__ */ jsx(
          CheckboxInput,
          {
            id: toggleId,
            ref,
            "aria-hidden": true,
            checked,
            disabled,
            onChange
          }
        )
      }
    );
  }
);
export {
  CheckboxMenuItem
};
//# sourceMappingURL=CheckboxMenuItem.js.map
