import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import styles from "./Link.module.css.js";
import classNames from "classnames";
const Link = forwardRef(
  function Link2({ children, className, kind = "primary", size = "medium", ...props }, ref) {
    return /* @__PURE__ */ jsx(
      "a",
      {
        ref,
        ...props,
        rel: "noreferrer noopener",
        className: classNames(styles.link, className),
        "data-kind": kind,
        "data-size": size,
        children
      }
    );
  }
);
export {
  Link
};
//# sourceMappingURL=Link.js.map
