import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import styles from "./InlineSpinner.module.css.js";
import SpinnerIcon from "@vector-im/compound-design-tokens/assets/web/icons/spinner";
const InlineSpinner = forwardRef(
  function InlineSpinner2({ size = 20, ...props }, ref) {
    return /* @__PURE__ */ jsx(
      SpinnerIcon,
      {
        ref,
        className: styles.icon,
        style: { width: size, height: size },
        ...props
      }
    );
  }
);
export {
  InlineSpinner
};
//# sourceMappingURL=InlineSpinner.js.map
