import { jsx } from "react/jsx-runtime";
import React, { forwardRef } from "react";
import classNames from "classnames";
import styles from "./IndicatorIcon.module.css.js";
const IndicatorIcon = forwardRef(function IconButton({ children, className, size = "100%", colour, indicator }, ref) {
  const classes = classNames(styles["indicator-icon"], className);
  return /* @__PURE__ */ jsx(
    "div",
    {
      ref,
      className: classes,
      "data-indicator": indicator,
      style: {
        "--cpd-icon-button-size": size,
        "--cpd-color-icon-tertiary": colour
      },
      children: React.Children.only(children)
    }
  );
});
export {
  IndicatorIcon
};
//# sourceMappingURL=IndicatorIcon.js.map
