"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const classNames = require("classnames");
const IndicatorIcon_module = require("./IndicatorIcon.module.css.cjs");
const IndicatorIcon = React.forwardRef(function IconButton({ children, className, size = "100%", colour, indicator }, ref) {
  const classes = classNames(IndicatorIcon_module.default["indicator-icon"], className);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref,
      className: classes,
      "data-indicator": indicator,
      style: {
        "--cpd-icon-button-size": size,
        "--cpd-color-icon-tertiary": colour
      },
      children: React.Children.only(children)
    }
  );
});
exports.IndicatorIcon = IndicatorIcon;
//# sourceMappingURL=IndicatorIcon.cjs.map
