import { jsx } from "react/jsx-runtime";
import React from "react";
import styles from "./BigIcon.module.css.js";
import classNames from "classnames";
function BigIcon({
  className,
  size = "large",
  destructive = false,
  success = false,
  children
}) {
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: classNames(styles.content, className, {
        [styles.destructive]: destructive,
        [styles.success]: success
      }),
      "data-size": size,
      children: React.Children.only(children)
    }
  );
}
export {
  BigIcon
};
//# sourceMappingURL=BigIcon.js.map
