"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const BigIcon_module = require("./BigIcon.module.css.cjs");
const classNames = require("classnames");
function BigIcon({
  className,
  size = "large",
  destructive = false,
  success = false,
  children
}) {
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      className: classNames(BigIcon_module.default.content, className, {
        [BigIcon_module.default.destructive]: destructive,
        [BigIcon_module.default.success]: success
      }),
      "data-size": size,
      children: React.Children.only(children)
    }
  );
}
exports.BigIcon = BigIcon;
//# sourceMappingURL=BigIcon.cjs.map
