import { jsx } from "react/jsx-runtime";
import { forwardRef, Children } from "react";
import classNames from "classnames";
import styles from "./Glass.module.css.js";
const Glass = forwardRef(
  ({ children, className, ...rest }, ref) => /* @__PURE__ */ jsx("div", { ref, className: classNames(className, styles.glass), ...rest, children: Children.only(children) })
);
Glass.displayName = "Glass";
export {
  Glass
};
//# sourceMappingURL=Glass.js.map
