import { jsxs, jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import { Message } from "@radix-ui/react-form";
import CheckCircleSolidIcon from "@vector-im/compound-design-tokens/assets/web/icons/check-circle-solid";
import ErrorIcon from "@vector-im/compound-design-tokens/assets/web/icons/error-solid";
import styles from "./form.module.css.js";
import classNames from "classnames";
import { InlineSpinner } from "../InlineSpinner/InlineSpinner.js";
const ErrorMessage = forwardRef(function ErrorMessage2({ children, className, ...props }, ref) {
  const classes = classNames(
    styles.message,
    styles["error-message"],
    className
  );
  return /* @__PURE__ */ jsxs(Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsx(ErrorIcon, {}),
    children
  ] });
});
const SuccessMessage = forwardRef(function SuccessMessage2({ children, className, ...props }, ref) {
  const classes = classNames(
    styles.message,
    styles["success-message"],
    className
  );
  return /* @__PURE__ */ jsxs(Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsx(CheckCircleSolidIcon, {}),
    children
  ] });
});
const LoadingMessage = forwardRef(function LoadingMessage2({ children, className, ...props }, ref) {
  const classes = classNames(styles.message, className);
  return /* @__PURE__ */ jsxs(Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsx(InlineSpinner, {}),
    children
  ] });
});
const HelpMessage = forwardRef(function HelpMessage2({ children, className, ...props }, ref) {
  const classes = classNames(styles.message, styles["help-message"], className);
  return /* @__PURE__ */ jsx(Message, { ref, ...props, className: classes, children });
});
export {
  ErrorMessage,
  HelpMessage,
  LoadingMessage,
  SuccessMessage
};
//# sourceMappingURL=Message.js.map
