"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactForm = require("@radix-ui/react-form");
const CheckCircleSolidIcon = require("@vector-im/compound-design-tokens/assets/web/icons/check-circle-solid");
const ErrorIcon = require("@vector-im/compound-design-tokens/assets/web/icons/error-solid");
const form_module = require("./form.module.css.cjs");
const classNames = require("classnames");
const InlineSpinner = require("../InlineSpinner/InlineSpinner.cjs");
const ErrorMessage = React.forwardRef(function ErrorMessage2({ children, className, ...props }, ref) {
  const classes = classNames(
    form_module.default.message,
    form_module.default["error-message"],
    className
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(reactForm.Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ErrorIcon, {}),
    children
  ] });
});
const SuccessMessage = React.forwardRef(function SuccessMessage2({ children, className, ...props }, ref) {
  const classes = classNames(
    form_module.default.message,
    form_module.default["success-message"],
    className
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(reactForm.Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsxRuntime.jsx(CheckCircleSolidIcon, {}),
    children
  ] });
});
const LoadingMessage = React.forwardRef(function LoadingMessage2({ children, className, ...props }, ref) {
  const classes = classNames(form_module.default.message, className);
  return /* @__PURE__ */ jsxRuntime.jsxs(reactForm.Message, { ref, ...props, className: classes, children: [
    /* @__PURE__ */ jsxRuntime.jsx(InlineSpinner.InlineSpinner, {}),
    children
  ] });
});
const HelpMessage = React.forwardRef(function HelpMessage2({ children, className, ...props }, ref) {
  const classes = classNames(form_module.default.message, form_module.default["help-message"], className);
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Message, { ref, ...props, className: classes, children });
});
exports.ErrorMessage = ErrorMessage;
exports.HelpMessage = HelpMessage;
exports.LoadingMessage = LoadingMessage;
exports.SuccessMessage = SuccessMessage;
//# sourceMappingURL=Message.cjs.map
