import { jsxs, jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import { Field } from "@radix-ui/react-form";
import styles from "./form.module.css.js";
import classNames from "classnames";
const InlineField = forwardRef(
  function InlineField2({ className, control, children, ...props }, ref) {
    const classes = classNames(styles["inline-field"], className);
    return /* @__PURE__ */ jsxs(Field, { ref, ...props, className: classes, children: [
      /* @__PURE__ */ jsx("div", { className: styles["inline-field-control"], children: control }),
      /* @__PURE__ */ jsx("div", { className: styles["inline-field-body"], children })
    ] });
  }
);
export {
  InlineField
};
//# sourceMappingURL=InlineField.js.map
