import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef } from "react";
import styles from "./Toggle.module.css.js";
import { Control } from "@radix-ui/react-form";
const ToggleInput = forwardRef(function Toggle({ className, ...props }, ref) {
  const classes = classNames(styles.container, className);
  return /* @__PURE__ */ jsxs("div", { className: classes, children: [
    /* @__PURE__ */ jsx(
      "input",
      {
        role: "switch",
        ref,
        className: styles.input,
        ...props,
        type: "checkbox"
      }
    ),
    /* @__PURE__ */ jsx("div", { className: styles.ui })
  ] });
});
const ToggleControl = forwardRef(function ToggleControl2(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(ToggleInput, { ref, ...props }) });
});
export {
  ToggleControl,
  ToggleInput
};
//# sourceMappingURL=Toggle.js.map
