"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const Toggle_module = require("./Toggle.module.css.cjs");
const reactForm = require("@radix-ui/react-form");
const ToggleInput = React.forwardRef(function Toggle({ className, ...props }, ref) {
  const classes = classNames(Toggle_module.default.container, className);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: classes, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        role: "switch",
        ref,
        className: Toggle_module.default.input,
        ...props,
        type: "checkbox"
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: Toggle_module.default.ui })
  ] });
});
const ToggleControl = React.forwardRef(function ToggleControl2(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(ToggleInput, { ref, ...props }) });
});
exports.ToggleControl = ToggleControl;
exports.ToggleInput = ToggleInput;
//# sourceMappingURL=Toggle.cjs.map
