import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import { Control } from "@radix-ui/react-form";
import styles from "./Text.module.css.js";
import classNames from "classnames";
const TextInput = forwardRef(
  function TextInput2({ className, enableLigatures, ...props }, ref) {
    const classes = classNames(styles.control, className, {
      [styles["enable-ligatures"]]: enableLigatures
    });
    return /* @__PURE__ */ jsx("input", { ref, ...props, className: classes });
  }
);
const TextControl = forwardRef(function TextControl2(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(TextInput, { ref, ...props }) });
});
export {
  TextControl,
  TextInput
};
//# sourceMappingURL=Text.js.map
