"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactForm = require("@radix-ui/react-form");
const Text_module = require("./Text.module.css.cjs");
const classNames = require("classnames");
const TextInput = React.forwardRef(
  function TextInput2({ className, enableLigatures, ...props }, ref) {
    const classes = classNames(Text_module.default.control, className, {
      [Text_module.default["enable-ligatures"]]: enableLigatures
    });
    return /* @__PURE__ */ jsxRuntime.jsx("input", { ref, ...props, className: classes });
  }
);
const TextControl = React.forwardRef(function TextControl2(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(TextInput, { ref, ...props }) });
});
exports.TextControl = TextControl;
exports.TextInput = TextInput;
//# sourceMappingURL=Text.cjs.map
