import { jsxs, jsx } from "react/jsx-runtime";
import { forwardRef, useId } from "react";
import { Label } from "../../Label.js";
import { HelpMessage } from "../../Message.js";
import { InlineField } from "../../InlineField.js";
import { Control } from "@radix-ui/react-form";
import { ToggleInput } from "../Toggle/Toggle.js";
const SettingsToggleInput = forwardRef(function Toggle({ className, label, helpMessage, disabledMessage, name, ...props }, ref) {
  const generatedId = useId();
  const id = props.id ?? generatedId;
  const content = /* @__PURE__ */ jsxs(
    InlineField,
    {
      className,
      name,
      control: /* @__PURE__ */ jsx(ToggleInput, { id, ref, ...props }),
      children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: id, children: label }),
        helpMessage && /* @__PURE__ */ jsx(HelpMessage, { children: helpMessage }),
        disabledMessage && props.disabled && /* @__PURE__ */ jsx(HelpMessage, { children: disabledMessage })
      ]
    }
  );
  return content;
});
const SettingsToggleControl = forwardRef(function ToggleControl(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(SettingsToggleInput, { ref, ...props }) });
});
export {
  SettingsToggleControl,
  SettingsToggleInput
};
//# sourceMappingURL=SettingsToggle.js.map
