"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const Label = require("../../Label.cjs");
const Message = require("../../Message.cjs");
const InlineField = require("../../InlineField.cjs");
const reactForm = require("@radix-ui/react-form");
const Toggle = require("../Toggle/Toggle.cjs");
const SettingsToggleInput = React.forwardRef(function Toggle$1({ className, label, helpMessage, disabledMessage, name, ...props }, ref) {
  const generatedId = React.useId();
  const id = props.id ?? generatedId;
  const content = /* @__PURE__ */ jsxRuntime.jsxs(
    InlineField.InlineField,
    {
      className,
      name,
      control: /* @__PURE__ */ jsxRuntime.jsx(Toggle.ToggleInput, { id, ref, ...props }),
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Label.Label, { htmlFor: id, children: label }),
        helpMessage && /* @__PURE__ */ jsxRuntime.jsx(Message.HelpMessage, { children: helpMessage }),
        disabledMessage && props.disabled && /* @__PURE__ */ jsxRuntime.jsx(Message.HelpMessage, { children: disabledMessage })
      ]
    }
  );
  return content;
});
const SettingsToggleControl = React.forwardRef(function ToggleControl(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(SettingsToggleInput, { ref, ...props }) });
});
exports.SettingsToggleControl = SettingsToggleControl;
exports.SettingsToggleInput = SettingsToggleInput;
//# sourceMappingURL=SettingsToggle.cjs.map
