import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef } from "react";
import { Control } from "@radix-ui/react-form";
import styles from "./Radio.module.css.js";
const RadioInput = forwardRef(function Radio({ className, ...props }, ref) {
  const classes = classNames(styles.container, className);
  return /* @__PURE__ */ jsxs("div", { className: classes, children: [
    /* @__PURE__ */ jsx("input", { ref, ...props, className: styles.input, type: "radio" }),
    /* @__PURE__ */ jsx("div", { className: styles.ui })
  ] });
});
const RadioControl = forwardRef(function RadioControl2(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(RadioInput, { ref, ...props }) });
});
export {
  RadioControl,
  RadioInput
};
//# sourceMappingURL=Radio.js.map
