import { jsx } from "react/jsx-runtime";
import { forwardRef, useReducer } from "react";
import { Control } from "@radix-ui/react-form";
import VisibilityOn from "@vector-im/compound-design-tokens/assets/web/icons/visibility-on";
import VisibilityOff from "@vector-im/compound-design-tokens/assets/web/icons/visibility-off";
import { ActionInput } from "../Action/Action.js";
const showState = {
  isHidden: true,
  icon: VisibilityOff,
  label: "Show",
  type: "password"
};
const hideState = {
  isHidden: false,
  icon: VisibilityOn,
  label: "Hide",
  type: "text"
};
const PasswordInput = forwardRef(function PasswordControl2(props, ref) {
  const [{ icon, label, type }, togglePasswordVisibility] = useReducer(
    (state) => !state.isHidden ? showState : hideState,
    showState
  );
  return /* @__PURE__ */ jsx(
    ActionInput,
    {
      ref,
      ...props,
      Icon: icon,
      actionLabel: label,
      onActionClick: () => togglePasswordVisibility(),
      type
    }
  );
});
const PasswordControl = forwardRef(function PasswordControl3(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(PasswordInput, { ref, ...props }) });
});
export {
  PasswordControl,
  PasswordInput
};
//# sourceMappingURL=Password.js.map
