"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactForm = require("@radix-ui/react-form");
const VisibilityOn = require("@vector-im/compound-design-tokens/assets/web/icons/visibility-on");
const VisibilityOff = require("@vector-im/compound-design-tokens/assets/web/icons/visibility-off");
const Action = require("../Action/Action.cjs");
const showState = {
  isHidden: true,
  icon: VisibilityOff,
  label: "Show",
  type: "password"
};
const hideState = {
  isHidden: false,
  icon: VisibilityOn,
  label: "Hide",
  type: "text"
};
const PasswordInput = React.forwardRef(function PasswordControl2(props, ref) {
  const [{ icon, label, type }, togglePasswordVisibility] = React.useReducer(
    (state) => !state.isHidden ? showState : hideState,
    showState
  );
  return /* @__PURE__ */ jsxRuntime.jsx(
    Action.ActionInput,
    {
      ref,
      ...props,
      Icon: icon,
      actionLabel: label,
      onActionClick: () => togglePasswordVisibility(),
      type
    }
  );
});
const PasswordControl = React.forwardRef(function PasswordControl3(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(PasswordInput, { ref, ...props }) });
});
exports.PasswordControl = PasswordControl;
exports.PasswordInput = PasswordInput;
//# sourceMappingURL=Password.cjs.map
