import { jsx, jsxs } from "react/jsx-runtime";
import React, { forwardRef } from "react";
import styles from "./MFA.module.css.js";
import classNames from "classnames";
import { Control } from "@radix-ui/react-form";
const Digit = ({ filled, selected }) => /* @__PURE__ */ jsx(
  "div",
  {
    className: styles.digit,
    "aria-hidden": "true",
    "data-filled": filled ? "" : void 0,
    "data-selected": selected ? "" : void 0
  }
);
const MFAInput = forwardRef(function MFAInput2({ className, length = 6, ...props }, ref) {
  const classes = classNames(styles.container, className);
  const [currentLength, setCurrentLength] = React.useState(0);
  const [selection, setSelection] = React.useState(
    null
  );
  const update = (event) => {
    const input = event.currentTarget;
    setCurrentLength(input.value?.length);
    if (document.activeElement !== input || input.selectionStart === null || input.selectionEnd === null) {
      setSelection(null);
    } else {
      setSelection([input.selectionStart, input.selectionEnd]);
    }
  };
  return /* @__PURE__ */ jsxs("div", { className: classes, children: [
    /* @__PURE__ */ jsx(
      "input",
      {
        ...props,
        inputMode: "numeric",
        type: "text",
        minLength: 0,
        maxLength: length,
        className: styles.control,
        pattern: `\\d{${length}}`,
        autoComplete: "one-time-code",
        onSelect: update,
        onFocus: update,
        onBlur: update,
        onMouseDown: update,
        onMouseMove: update,
        onMouseUp: update,
        onChange: update,
        ref
      }
    ),
    Array.from(Array(length).keys()).map((index) => /* @__PURE__ */ jsx(
      Digit,
      {
        filled: index < currentLength,
        selected: !!selection && index >= selection[0] && index < selection[1]
      },
      index
    ))
  ] });
});
const MFAControl = forwardRef(function ActionControl(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(MFAInput, { ref, ...props }) });
});
export {
  MFAControl,
  MFAInput
};
//# sourceMappingURL=MFA.js.map
