"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const MFA_module = require("./MFA.module.css.cjs");
const classNames = require("classnames");
const reactForm = require("@radix-ui/react-form");
const Digit = ({ filled, selected }) => /* @__PURE__ */ jsxRuntime.jsx(
  "div",
  {
    className: MFA_module.default.digit,
    "aria-hidden": "true",
    "data-filled": filled ? "" : void 0,
    "data-selected": selected ? "" : void 0
  }
);
const MFAInput = React.forwardRef(function MFAInput2({ className, length = 6, ...props }, ref) {
  const classes = classNames(MFA_module.default.container, className);
  const [currentLength, setCurrentLength] = React.useState(0);
  const [selection, setSelection] = React.useState(
    null
  );
  const update = (event) => {
    const input = event.currentTarget;
    setCurrentLength(input.value?.length);
    if (document.activeElement !== input || input.selectionStart === null || input.selectionEnd === null) {
      setSelection(null);
    } else {
      setSelection([input.selectionStart, input.selectionEnd]);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: classes, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        ...props,
        inputMode: "numeric",
        type: "text",
        minLength: 0,
        maxLength: length,
        className: MFA_module.default.control,
        pattern: `\\d{${length}}`,
        autoComplete: "one-time-code",
        onSelect: update,
        onFocus: update,
        onBlur: update,
        onMouseDown: update,
        onMouseMove: update,
        onMouseUp: update,
        onChange: update,
        ref
      }
    ),
    Array.from(Array(length).keys()).map((index) => /* @__PURE__ */ jsxRuntime.jsx(
      Digit,
      {
        filled: index < currentLength,
        selected: !!selection && index >= selection[0] && index < selection[1]
      },
      index
    ))
  ] });
});
const MFAControl = React.forwardRef(function ActionControl(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(MFAInput, { ref, ...props }) });
});
exports.MFAControl = MFAControl;
exports.MFAInput = MFAInput;
//# sourceMappingURL=MFA.cjs.map
