import { jsx, jsxs } from "react/jsx-runtime";
import { forwardRef, useReducer, useRef, useState, useEffect, useCallback } from "react";
import { Submit, ValidityState } from "@radix-ui/react-form";
import CheckIcon from "@vector-im/compound-design-tokens/assets/web/icons/check";
import CloseIcon from "@vector-im/compound-design-tokens/assets/web/icons/close";
import styles from "./EditInPlace.module.css.js";
import { Root } from "../../Root.js";
import { Field } from "../../Field.js";
import { Label } from "../../Label.js";
import { TextControl } from "../Text/Text.js";
import { Tooltip } from "../../../Tooltip/Tooltip.js";
import { Button } from "../../../Button/Button.js";
import { LoadingMessage, SuccessMessage, HelpMessage } from "../../Message.js";
function reducer(state, action) {
  switch (action) {
    case 0:
      if (state === 0 || state === 3) return 1;
      else return state;
    case 1:
      return 2;
    case 4:
      return 0;
    case 2:
      if (state === 2) return 3;
      else return state;
    case 3:
      if (state === 2) return 0;
      else return state;
    case 5:
      if (state === 3) return 0;
      else return state;
  }
  assertNever(action);
}
function assertNever(value) {
  throw new Error(`Unreachable value: ${value}`);
}
const EditInPlace = forwardRef(
  function EditInPlace2({
    className,
    label,
    onSave,
    onCancel,
    onInput,
    onClearServerErrors,
    serverInvalid,
    saveButtonLabel,
    cancelButtonLabel,
    savedLabel,
    savingLabel,
    helpLabel,
    disabled,
    children,
    ...props
  }, ref) {
    const [state, dispatch] = useReducer(
      reducer,
      0
      /* Initial */
    );
    const isFocusWithinRef = useRef(false);
    const [isFocusWithin, setFocusWithin] = useState(false);
    const shouldShowSaveButton = state === 1 || state === 2 || isFocusWithin;
    const hideTimer = useRef(
      void 0
    );
    useEffect(() => {
      if (state === 3) {
        hideTimer.current = setTimeout(() => {
          dispatch(
            5
            /* SavedTimeout */
          );
          hideTimer.current = void 0;
        }, 2e3);
      }
      return () => {
        if (hideTimer.current) clearTimeout(hideTimer.current);
        hideTimer.current = void 0;
      };
    }, [state]);
    const formRef = useRef(null);
    const saveButtonRef = useRef(null);
    const cancelButtonRef = useRef(null);
    const onFocus = useCallback(() => {
      if (isFocusWithinRef.current) return;
      isFocusWithinRef.current = true;
      setFocusWithin(true);
    }, [isFocusWithin, setFocusWithin]);
    const onBlur = useCallback(
      (e) => {
        if (!isFocusWithinRef.current) return;
        if (e.currentTarget.contains(e.relatedTarget)) return;
        isFocusWithinRef.current = false;
        setFocusWithin(false);
      },
      [isFocusWithin, setFocusWithin]
    );
    const onInputHandler = useCallback(
      (e) => {
        dispatch(
          0
          /* Touch */
        );
        onInput?.(e);
      },
      [dispatch, onInput]
    );
    const onFormSubmit = useCallback(
      async (e) => {
        e.preventDefault();
        if (state === 0) {
          return;
        }
        try {
          dispatch(
            1
            /* Save */
          );
          saveButtonRef.current?.blur();
          await onSave?.(e);
          dispatch(
            2
            /* Saved */
          );
        } catch {
          dispatch(
            3
            /* SaveError */
          );
        }
      },
      [onSave, state, hideTimer]
    );
    const onFormReset = useCallback(
      (e) => {
        cancelButtonRef.current?.blur();
        onCancel?.(e);
        dispatch(
          4
          /* Cancel */
        );
      },
      [cancelButtonRef, onCancel]
    );
    return /* @__PURE__ */ jsx(
      Root,
      {
        className,
        onSubmit: onFormSubmit,
        onReset: onFormReset,
        onFocus,
        onBlur,
        onClearServerErrors,
        ref: formRef,
        children: /* @__PURE__ */ jsxs(Field, { name: "input", serverInvalid, children: [
          /* @__PURE__ */ jsx(Label, { children: label }),
          /* @__PURE__ */ jsxs("div", { className: styles.controls, children: [
            /* @__PURE__ */ jsx(
              TextControl,
              {
                ref,
                ...props,
                onInput: onInputHandler,
                disabled: disabled || state === 2
                /* Saving */
              }
            ),
            shouldShowSaveButton && /* @__PURE__ */ jsxs("div", { className: styles["button-group"], children: [
              /* @__PURE__ */ jsx(Tooltip, { label: saveButtonLabel, children: /* @__PURE__ */ jsx(Submit, { asChild: true, children: /* @__PURE__ */ jsx(
                Button,
                {
                  type: "submit",
                  kind: "primary",
                  size: "sm",
                  ref: saveButtonRef,
                  disabled: state !== 1,
                  iconOnly: true,
                  Icon: CheckIcon
                }
              ) }) }),
              /* @__PURE__ */ jsx(Tooltip, { label: cancelButtonLabel, children: /* @__PURE__ */ jsx(
                Button,
                {
                  type: "reset",
                  kind: "secondary",
                  size: "sm",
                  ref: cancelButtonRef,
                  className: styles.button,
                  disabled: state === 2,
                  iconOnly: true,
                  Icon: CloseIcon
                }
              ) })
            ] })
          ] }),
          state === 2 ? /* @__PURE__ */ jsx(LoadingMessage, { children: savingLabel }) : children,
          savedLabel && state === 3 && /* @__PURE__ */ jsx(SuccessMessage, { children: savedLabel }),
          helpLabel && (state === 0 || state === 1) && /* @__PURE__ */ jsx(ValidityState, { children: (validity) => (validity === void 0 || validity.valid) && !serverInvalid && /* @__PURE__ */ jsx(HelpMessage, { children: helpLabel }) })
        ] })
      }
    );
  }
);
export {
  EditInPlace
};
//# sourceMappingURL=EditInPlace.js.map
