"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const reactForm = require("@radix-ui/react-form");
const CheckIcon = require("@vector-im/compound-design-tokens/assets/web/icons/check");
const CloseIcon = require("@vector-im/compound-design-tokens/assets/web/icons/close");
const EditInPlace_module = require("./EditInPlace.module.css.cjs");
const Root = require("../../Root.cjs");
const Field = require("../../Field.cjs");
const Label = require("../../Label.cjs");
const Text = require("../Text/Text.cjs");
const Tooltip = require("../../../Tooltip/Tooltip.cjs");
const Button = require("../../../Button/Button.cjs");
const Message = require("../../Message.cjs");
function reducer(state, action) {
  switch (action) {
    case 0:
      if (state === 0 || state === 3) return 1;
      else return state;
    case 1:
      return 2;
    case 4:
      return 0;
    case 2:
      if (state === 2) return 3;
      else return state;
    case 3:
      if (state === 2) return 0;
      else return state;
    case 5:
      if (state === 3) return 0;
      else return state;
  }
  assertNever(action);
}
function assertNever(value) {
  throw new Error(`Unreachable value: ${value}`);
}
const EditInPlace = React.forwardRef(
  function EditInPlace2({
    className,
    label,
    onSave,
    onCancel,
    onInput,
    onClearServerErrors,
    serverInvalid,
    saveButtonLabel,
    cancelButtonLabel,
    savedLabel,
    savingLabel,
    helpLabel,
    disabled,
    children,
    ...props
  }, ref) {
    const [state, dispatch] = React.useReducer(
      reducer,
      0
      /* Initial */
    );
    const isFocusWithinRef = React.useRef(false);
    const [isFocusWithin, setFocusWithin] = React.useState(false);
    const shouldShowSaveButton = state === 1 || state === 2 || isFocusWithin;
    const hideTimer = React.useRef(
      void 0
    );
    React.useEffect(() => {
      if (state === 3) {
        hideTimer.current = setTimeout(() => {
          dispatch(
            5
            /* SavedTimeout */
          );
          hideTimer.current = void 0;
        }, 2e3);
      }
      return () => {
        if (hideTimer.current) clearTimeout(hideTimer.current);
        hideTimer.current = void 0;
      };
    }, [state]);
    const formRef = React.useRef(null);
    const saveButtonRef = React.useRef(null);
    const cancelButtonRef = React.useRef(null);
    const onFocus = React.useCallback(() => {
      if (isFocusWithinRef.current) return;
      isFocusWithinRef.current = true;
      setFocusWithin(true);
    }, [isFocusWithin, setFocusWithin]);
    const onBlur = React.useCallback(
      (e) => {
        if (!isFocusWithinRef.current) return;
        if (e.currentTarget.contains(e.relatedTarget)) return;
        isFocusWithinRef.current = false;
        setFocusWithin(false);
      },
      [isFocusWithin, setFocusWithin]
    );
    const onInputHandler = React.useCallback(
      (e) => {
        dispatch(
          0
          /* Touch */
        );
        onInput?.(e);
      },
      [dispatch, onInput]
    );
    const onFormSubmit = React.useCallback(
      async (e) => {
        e.preventDefault();
        if (state === 0) {
          return;
        }
        try {
          dispatch(
            1
            /* Save */
          );
          saveButtonRef.current?.blur();
          await onSave?.(e);
          dispatch(
            2
            /* Saved */
          );
        } catch {
          dispatch(
            3
            /* SaveError */
          );
        }
      },
      [onSave, state, hideTimer]
    );
    const onFormReset = React.useCallback(
      (e) => {
        cancelButtonRef.current?.blur();
        onCancel?.(e);
        dispatch(
          4
          /* Cancel */
        );
      },
      [cancelButtonRef, onCancel]
    );
    return /* @__PURE__ */ jsxRuntime.jsx(
      Root.Root,
      {
        className,
        onSubmit: onFormSubmit,
        onReset: onFormReset,
        onFocus,
        onBlur,
        onClearServerErrors,
        ref: formRef,
        children: /* @__PURE__ */ jsxRuntime.jsxs(Field.Field, { name: "input", serverInvalid, children: [
          /* @__PURE__ */ jsxRuntime.jsx(Label.Label, { children: label }),
          /* @__PURE__ */ jsxRuntime.jsxs("div", { className: EditInPlace_module.default.controls, children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              Text.TextControl,
              {
                ref,
                ...props,
                onInput: onInputHandler,
                disabled: disabled || state === 2
                /* Saving */
              }
            ),
            shouldShowSaveButton && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: EditInPlace_module.default["button-group"], children: [
              /* @__PURE__ */ jsxRuntime.jsx(Tooltip.Tooltip, { label: saveButtonLabel, children: /* @__PURE__ */ jsxRuntime.jsx(reactForm.Submit, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(
                Button.Button,
                {
                  type: "submit",
                  kind: "primary",
                  size: "sm",
                  ref: saveButtonRef,
                  disabled: state !== 1,
                  iconOnly: true,
                  Icon: CheckIcon
                }
              ) }) }),
              /* @__PURE__ */ jsxRuntime.jsx(Tooltip.Tooltip, { label: cancelButtonLabel, children: /* @__PURE__ */ jsxRuntime.jsx(
                Button.Button,
                {
                  type: "reset",
                  kind: "secondary",
                  size: "sm",
                  ref: cancelButtonRef,
                  className: EditInPlace_module.default.button,
                  disabled: state === 2,
                  iconOnly: true,
                  Icon: CloseIcon
                }
              ) })
            ] })
          ] }),
          state === 2 ? /* @__PURE__ */ jsxRuntime.jsx(Message.LoadingMessage, { children: savingLabel }) : children,
          savedLabel && state === 3 && /* @__PURE__ */ jsxRuntime.jsx(Message.SuccessMessage, { children: savedLabel }),
          helpLabel && (state === 0 || state === 1) && /* @__PURE__ */ jsxRuntime.jsx(reactForm.ValidityState, { children: (validity) => (validity === void 0 || validity.valid) && !serverInvalid && /* @__PURE__ */ jsxRuntime.jsx(Message.HelpMessage, { children: helpLabel }) })
        ] })
      }
    );
  }
);
exports.EditInPlace = EditInPlace;
//# sourceMappingURL=EditInPlace.cjs.map
