import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef } from "react";
import CheckIcon from "@vector-im/compound-design-tokens/assets/web/icons/check";
import { Control } from "@radix-ui/react-form";
import styles from "./Checkbox.module.css.js";
const CheckboxInput = forwardRef(
  function Checkbox({ className, ...props }, ref) {
    const classes = classNames(styles.container, className);
    return /* @__PURE__ */ jsxs("div", { className: classes, children: [
      /* @__PURE__ */ jsx("input", { ref, className: styles.input, ...props, type: "checkbox" }),
      /* @__PURE__ */ jsx("div", { className: styles.ui, children: /* @__PURE__ */ jsx(CheckIcon, { "aria-hidden": true }) })
    ] });
  }
);
const CheckboxControl = forwardRef(function CheckboxControl2(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(CheckboxInput, { ref, ...props }) });
});
export {
  CheckboxControl,
  CheckboxInput
};
//# sourceMappingURL=Checkbox.js.map
