"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const CheckIcon = require("@vector-im/compound-design-tokens/assets/web/icons/check");
const reactForm = require("@radix-ui/react-form");
const Checkbox_module = require("./Checkbox.module.css.cjs");
const CheckboxInput = React.forwardRef(
  function Checkbox({ className, ...props }, ref) {
    const classes = classNames(Checkbox_module.default.container, className);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: classes, children: [
      /* @__PURE__ */ jsxRuntime.jsx("input", { ref, className: Checkbox_module.default.input, ...props, type: "checkbox" }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: Checkbox_module.default.ui, children: /* @__PURE__ */ jsxRuntime.jsx(CheckIcon, { "aria-hidden": true }) })
    ] });
  }
);
const CheckboxControl = React.forwardRef(function CheckboxControl2(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(CheckboxInput, { ref, ...props }) });
});
exports.CheckboxControl = CheckboxControl;
exports.CheckboxInput = CheckboxInput;
//# sourceMappingURL=Checkbox.cjs.map
