import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef, useId } from "react";
import styles from "./Action.module.css.js";
import { Control } from "@radix-ui/react-form";
import { Tooltip } from "../../../Tooltip/Tooltip.js";
import { TextInput } from "../Text/Text.js";
const ActionInput = forwardRef(
  function ActionControl2({ Icon, className, actionLabel, onActionClick, ...props }, ref) {
    const id = useId();
    const classes = classNames(styles.container, className);
    return /* @__PURE__ */ jsxs("div", { className: classes, id, children: [
      /* @__PURE__ */ jsx(TextInput, { ref, ...props, className: styles.control }),
      /* @__PURE__ */ jsx(Tooltip, { label: actionLabel, children: /* @__PURE__ */ jsx(
        "button",
        {
          type: "button",
          className: styles.action,
          onClick: onActionClick,
          "aria-controls": id,
          children: /* @__PURE__ */ jsx(Icon, { "aria-hidden": true })
        }
      ) })
    ] });
  }
);
const ActionControl = forwardRef(function ActionControl3(props, ref) {
  return /* @__PURE__ */ jsx(Control, { asChild: true, children: /* @__PURE__ */ jsx(ActionInput, { ref, ...props }) });
});
export {
  ActionControl,
  ActionInput
};
//# sourceMappingURL=Action.js.map
