"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const Action_module = require("./Action.module.css.cjs");
const reactForm = require("@radix-ui/react-form");
const Tooltip = require("../../../Tooltip/Tooltip.cjs");
const Text = require("../Text/Text.cjs");
const ActionInput = React.forwardRef(
  function ActionControl2({ Icon, className, actionLabel, onActionClick, ...props }, ref) {
    const id = React.useId();
    const classes = classNames(Action_module.default.container, className);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: classes, id, children: [
      /* @__PURE__ */ jsxRuntime.jsx(Text.TextInput, { ref, ...props, className: Action_module.default.control }),
      /* @__PURE__ */ jsxRuntime.jsx(Tooltip.Tooltip, { label: actionLabel, children: /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          type: "button",
          className: Action_module.default.action,
          onClick: onActionClick,
          "aria-controls": id,
          children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { "aria-hidden": true })
        }
      ) })
    ] });
  }
);
const ActionControl = React.forwardRef(function ActionControl3(props, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(reactForm.Control, { asChild: true, children: /* @__PURE__ */ jsxRuntime.jsx(ActionInput, { ref, ...props }) });
});
exports.ActionControl = ActionControl;
exports.ActionInput = ActionInput;
//# sourceMappingURL=Action.cjs.map
