"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const ChevronDown = require("@vector-im/compound-design-tokens/assets/web/icons/chevron-down");
const CheckIcon = require("@vector-im/compound-design-tokens/assets/web/icons/check");
const ErrorIcon = require("@vector-im/compound-design-tokens/assets/web/icons/error-solid");
const React = require("react");
const classNames = require("classnames");
const Dropdown_module = require("./Dropdown.module.css.cjs");
const react = require("@floating-ui/react");
const Dropdown = React.forwardRef(
  function Dropdown2({
    className,
    label,
    placeholder,
    helpLabel,
    onValueChange,
    error,
    value: controlledValue,
    defaultValue,
    values,
    ...props
  }, ref) {
    const [uncontrolledValue, setUncontrolledValue] = React.useState(defaultValue);
    const value = controlledValue ?? uncontrolledValue;
    const text = React.useMemo(
      () => value === void 0 ? placeholder : values.find(([v]) => v === value)?.[1] ?? placeholder,
      [value, values, placeholder]
    );
    const setValue = React.useCallback(
      (value2) => {
        setUncontrolledValue(value2);
        onValueChange?.(value2);
      },
      [setUncontrolledValue, onValueChange]
    );
    const [open, setOpen, dropdownRef] = useOpen();
    const { listRef, onComboboxKeyDown, onOptionKeyDown } = useKeyboardShortcut(
      open,
      setOpen,
      setValue
    );
    const buttonRef = React.useRef(null);
    React.useEffect(() => {
      if (value !== void 0) buttonRef.current?.focus();
    }, [value]);
    const hasPlaceholder = text === placeholder;
    const buttonClasses = classNames({
      [Dropdown_module.default.placeholder]: hasPlaceholder
    });
    const borderClasses = classNames(Dropdown_module.default.border, {
      [Dropdown_module.default.open]: open
    });
    const contentClasses = classNames(Dropdown_module.default.content, {
      [Dropdown_module.default.open]: open
    });
    const labelId = react.useId();
    const contentId = react.useId();
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        ref: dropdownRef,
        className: classNames(className, Dropdown_module.default.container),
        "aria-invalid": Boolean(error),
        children: [
          /* @__PURE__ */ jsxRuntime.jsx("label", { id: labelId, children: label }),
          /* @__PURE__ */ jsxRuntime.jsxs(
            "button",
            {
              className: buttonClasses,
              role: "combobox",
              "aria-haspopup": "listbox",
              "aria-labelledby": labelId,
              "aria-controls": contentId,
              "aria-expanded": open,
              ref: (element) => {
                buttonRef.current = element;
                if (typeof ref === "function") {
                  ref(element);
                } else if (ref) {
                  ref.current = element;
                }
              },
              onClick: () => setOpen((_open) => !_open),
              onKeyDown: onComboboxKeyDown,
              ...props,
              children: [
                text,
                /* @__PURE__ */ jsxRuntime.jsx(ChevronDown, { width: "24", height: "24" })
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: borderClasses }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { className: contentClasses, children: /* @__PURE__ */ jsxRuntime.jsx(
            "ul",
            {
              ref: listRef,
              id: contentId,
              role: "listbox",
              className: Dropdown_module.default.content,
              children: values.map(([v, text2]) => /* @__PURE__ */ jsxRuntime.jsx(
                DropdownItem,
                {
                  isDisplayed: open,
                  isSelected: value === v,
                  onClick: () => {
                    setOpen(false);
                    setValue(v);
                  },
                  onKeyDown: (e) => onOptionKeyDown(e, v),
                  children: text2
                },
                v
              ))
            }
          ) }),
          !error && helpLabel && /* @__PURE__ */ jsxRuntime.jsx("span", { className: Dropdown_module.default.help, children: helpLabel }),
          error && /* @__PURE__ */ jsxRuntime.jsxs("span", { className: Dropdown_module.default.error, children: [
            /* @__PURE__ */ jsxRuntime.jsx(ErrorIcon, { width: "20", height: "20" }),
            error
          ] })
        ]
      }
    );
  }
);
const DropdownItem = React.memo(function DropdownItem2({
  children,
  isSelected,
  isDisplayed,
  ...props
}) {
  const ref = React.useRef(null);
  React.useEffect(() => {
    if (isSelected && isDisplayed) {
      ref.current?.focus();
    }
  }, [isSelected, isDisplayed]);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "li",
    {
      tabIndex: 0,
      role: "option",
      ref,
      "aria-selected": isSelected,
      ...props,
      children: [
        children,
        " ",
        isSelected && /* @__PURE__ */ jsxRuntime.jsx(CheckIcon, { width: "20", height: "20" })
      ]
    }
  );
});
function useOpen() {
  const [open, setOpen] = React.useState(false);
  const ref = React.useRef(null);
  React.useEffect(() => {
    const closeIfOutside = (e) => {
      if (ref.current && !ref.current.contains(e.target)) {
        setOpen(false);
      }
    };
    document.addEventListener("click", closeIfOutside);
    return () => document.removeEventListener("click", closeIfOutside);
  }, [setOpen]);
  return [open, setOpen, ref];
}
function useKeyboardShortcut(open, setOpen, setValue) {
  const listRef = React.useRef(null);
  const onComboboxKeyDown = React.useCallback(
    ({ key }) => {
      switch (key) {
        // Enter and Space already managed because it's a button
        case "Escape":
          setOpen(false);
          break;
        case "ArrowDown":
          setOpen(true);
          if (open) {
            listRef.current?.firstElementChild?.focus();
          }
          break;
        case "ArrowUp":
          setOpen(true);
          break;
        case "Home": {
          setOpen(true);
          Promise.resolve().then(() => {
            listRef.current?.firstElementChild?.focus();
          });
          break;
        }
        case "End": {
          setOpen(true);
          Promise.resolve().then(() => {
            listRef.current?.lastElementChild?.focus();
          });
          break;
        }
      }
    },
    [listRef, open, setOpen]
  );
  const onOptionKeyDown = React.useCallback(
    (evt, value) => {
      const { key, altKey } = evt;
      evt.stopPropagation();
      evt.preventDefault();
      switch (key) {
        case "Enter":
        case " ": {
          setValue(value);
          setOpen(false);
          break;
        }
        case "Tab":
        case "Escape":
          setOpen(false);
          break;
        case "ArrowDown": {
          const currentFocus = document.activeElement;
          if (listRef.current?.contains(currentFocus) && currentFocus) {
            currentFocus.nextElementSibling?.focus();
          }
          break;
        }
        case "ArrowUp": {
          if (altKey) {
            setValue(value);
            setOpen(false);
          } else {
            const currentFocus = document.activeElement;
            if (listRef.current?.contains(currentFocus) && currentFocus) {
              currentFocus.previousElementSibling?.focus();
            }
          }
          break;
        }
        case "Home": {
          listRef.current?.firstElementChild?.focus();
          break;
        }
        case "End": {
          listRef.current?.lastElementChild?.focus();
          break;
        }
      }
    },
    [listRef, setValue, setOpen]
  );
  return { listRef, onComboboxKeyDown, onOptionKeyDown };
}
exports.Dropdown = Dropdown;
//# sourceMappingURL=Dropdown.cjs.map
