import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import { UnstyledButton } from "../Button/UnstyledButton.js";
import styles from "./ChatFilter.module.css.js";
const ChatFilter = forwardRef(function ChatFilter2({ children, selected, ...props }, ref) {
  return /* @__PURE__ */ jsx(
    UnstyledButton,
    {
      ...props,
      className: styles["chat-filter"],
      "aria-selected": selected,
      as: "button",
      ref,
      tabIndex: 0,
      children
    }
  );
});
export {
  ChatFilter
};
//# sourceMappingURL=ChatFilter.js.map
