import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
const UnstyledButton = forwardRef(function UnstyledButton2({
  as,
  children,
  className,
  disabled,
  ...props
}, ref) {
  const Component = as || "button";
  const {
    onClick,
    onSubmit,
    onPointerDown,
    onPointerUp,
    onKeyDown,
    onKeyUp,
    onKeyPress,
    ...restProps
  } = props;
  const eventHandlers = disabled ? {} : {
    onClick,
    onSubmit,
    onPointerDown,
    onPointerUp,
    onKeyDown,
    onKeyUp,
    onKeyPress
  };
  return /* @__PURE__ */ jsx(
    Component,
    {
      ref,
      className,
      role: as === "a" ? "link" : "button",
      tabIndex: 0,
      "aria-disabled": disabled,
      ...restProps,
      ...eventHandlers,
      children
    }
  );
});
export {
  UnstyledButton
};
//# sourceMappingURL=UnstyledButton.js.map
