"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const UnstyledButton = React.forwardRef(function UnstyledButton2({
  as,
  children,
  className,
  disabled,
  ...props
}, ref) {
  const Component = as || "button";
  const {
    onClick,
    onSubmit,
    onPointerDown,
    onPointerUp,
    onKeyDown,
    onKeyUp,
    onKeyPress,
    ...restProps
  } = props;
  const eventHandlers = disabled ? {} : {
    onClick,
    onSubmit,
    onPointerDown,
    onPointerUp,
    onKeyDown,
    onKeyUp,
    onKeyPress
  };
  return /* @__PURE__ */ jsxRuntime.jsx(
    Component,
    {
      ref,
      className,
      role: as === "a" ? "link" : "button",
      tabIndex: 0,
      "aria-disabled": disabled,
      ...restProps,
      ...eventHandlers,
      children
    }
  );
});
exports.UnstyledButton = UnstyledButton;
//# sourceMappingURL=UnstyledButton.cjs.map
