import { jsx } from "react/jsx-runtime";
import React, { forwardRef } from "react";
import classNames from "classnames";
import styles from "./IconButton.module.css.js";
import { UnstyledButton } from "../UnstyledButton.js";
import { IndicatorIcon } from "../../Icon/IndicatorIcon/IndicatorIcon.js";
import { Tooltip } from "../../Tooltip/Tooltip.js";
const IconButton = forwardRef(function IconButton2({
  kind = "primary",
  children,
  className,
  indicator,
  size = "32px",
  style,
  disabled,
  destructive,
  tooltip,
  noBackground = false,
  ...props
}, ref) {
  const classes = classNames(styles["icon-button"], className, {
    [styles.destructive]: destructive,
    [styles["no-background"]]: noBackground
  });
  const button = /* @__PURE__ */ jsx(
    UnstyledButton,
    {
      as: "button",
      ref,
      className: classes,
      style: {
        "--cpd-icon-button-size": size,
        ...style
      },
      disabled,
      ...props,
      "data-indicator": indicator,
      "data-kind": kind,
      children: /* @__PURE__ */ jsx(
        IndicatorIcon,
        {
          indicator,
          colour: disabled ? "var(--cpd-color-icon-disabled)" : void 0,
          children: React.Children.only(children)
        }
      )
    }
  );
  return tooltip ? /* @__PURE__ */ jsx(Tooltip, { label: tooltip, children: button }) : button;
});
export {
  IconButton
};
//# sourceMappingURL=IconButton.js.map
