"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const classNames = require("classnames");
const IconButton_module = require("./IconButton.module.css.cjs");
const UnstyledButton = require("../UnstyledButton.cjs");
const IndicatorIcon = require("../../Icon/IndicatorIcon/IndicatorIcon.cjs");
const Tooltip = require("../../Tooltip/Tooltip.cjs");
const IconButton = React.forwardRef(function IconButton2({
  kind = "primary",
  children,
  className,
  indicator,
  size = "32px",
  style,
  disabled,
  destructive,
  tooltip,
  noBackground = false,
  ...props
}, ref) {
  const classes = classNames(IconButton_module.default["icon-button"], className, {
    [IconButton_module.default.destructive]: destructive,
    [IconButton_module.default["no-background"]]: noBackground
  });
  const button = /* @__PURE__ */ jsxRuntime.jsx(
    UnstyledButton.UnstyledButton,
    {
      as: "button",
      ref,
      className: classes,
      style: {
        "--cpd-icon-button-size": size,
        ...style
      },
      disabled,
      ...props,
      "data-indicator": indicator,
      "data-kind": kind,
      children: /* @__PURE__ */ jsxRuntime.jsx(
        IndicatorIcon.IndicatorIcon,
        {
          indicator,
          colour: disabled ? "var(--cpd-color-icon-disabled)" : void 0,
          children: React.Children.only(children)
        }
      )
    }
  );
  return tooltip ? /* @__PURE__ */ jsxRuntime.jsx(Tooltip.Tooltip, { label: tooltip, children: button }) : button;
});
exports.IconButton = IconButton;
//# sourceMappingURL=IconButton.cjs.map
