import { jsxs, jsx } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef } from "react";
import styles from "./Button.module.css.js";
import { UnstyledButton } from "./UnstyledButton.js";
const Button = forwardRef(function Button2({
  as,
  kind: kindProp = "primary",
  size = "lg",
  children,
  className,
  iconOnly,
  Icon,
  destructive: destructiveProp,
  disabled,
  ...props
}, ref) {
  const [kind, destructive] = kindProp === "destructive" ? ["secondary", true] : [kindProp, destructiveProp];
  const classes = classNames(styles.button, className, {
    [styles["has-icon"]]: Icon,
    [styles["icon-only"]]: iconOnly,
    [styles.destructive]: destructive
  });
  const iconSize = iconOnly && size === "lg" ? 24 : 20;
  return /* @__PURE__ */ jsxs(
    UnstyledButton,
    {
      ...props,
      as: as || "button",
      ref,
      className: classes,
      "data-size": size,
      "data-kind": kind,
      tabIndex: 0,
      disabled,
      children: [
        Icon && /* @__PURE__ */ jsx(
          Icon,
          {
            width: iconSize,
            height: iconSize,
            className: styles.icon,
            "aria-hidden": true
          }
        ),
        children
      ]
    }
  );
});
export {
  Button
};
//# sourceMappingURL=Button.js.map
